/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.parts;

import de.willuhn.annotation.Lifecycle;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.action.FileClose;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;

@Lifecycle(value=Lifecycle.Type.CONTEXT)
public class SysTray {
    public static final String KEY_MINIMIZED = "__systray-minimize";
    private TrayItem item = null;
    private boolean activity = false;

    public void start() {
        if (this.item != null) {
            return;
        }
        Tray sysTray = GUI.getDisplay().getSystemTray();
        if (sysTray == null) {
            return;
        }
        this.item = new TrayItem(sysTray, 0);
        this.item.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                SysTray.this.getMenu();
            }
        });
        this.item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysTray.this.toggle();
            }
        });
        this.refresh();
    }

    public void setNewActivity(boolean b) {
        this.activity = b;
        this.refresh();
    }

    private void toggle() {
        try {
            Shell shell = GUI.getShell();
            if (shell == null || shell.isDisposed()) {
                return;
            }
            boolean minimized = shell.getData(KEY_MINIMIZED) != null;
            Logger.info((String)("shell was minimized: " + minimized));
            if (!minimized) {
                Logger.info((String)"minimize to systray");
                shell.setData(KEY_MINIMIZED, (Object)Boolean.TRUE);
                shell.setVisible(false);
                shell.setMinimized(true);
                return;
            }
            Logger.info((String)"restore from systray");
            shell.setVisible(true);
            shell.setMinimized(false);
            shell.setData(KEY_MINIMIZED, null);
            shell.forceActive();
        }
        catch (Exception e2) {
            Logger.error((String)"unable to restore", (Throwable)e2);
        }
    }

    public void stop() {
        try {
            if (this.item != null && !this.item.isDisposed()) {
                this.item.dispose();
            }
        }
        finally {
            this.item = null;
        }
    }

    private void getMenu() {
        try {
            final I18N i18n = Application.getI18n();
            Menu menu = new Menu((Decorations)GUI.getShell(), 8);
            MenuItem restore = new MenuItem(menu, 8);
            restore.setText(i18n.tr("Fenster wiederherstellen"));
            restore.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    SysTray.this.toggle();
                }
            });
            MenuItem shutdown = new MenuItem(menu, 8);
            shutdown.setText(i18n.tr("Programm beenden"));
            shutdown.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    try {
                        if (Application.getCallback().askUser(i18n.tr("Jameica wirklich beenden?"))) {
                            new FileClose().handleAction(null);
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                    }
                    catch (Exception e2) {
                        Logger.error((String)"unable to shutdown", (Throwable)e2);
                    }
                }
            });
            menu.setVisible(true);
        }
        catch (Exception e) {
            Logger.error((String)"unable to display menu", (Throwable)e);
        }
    }

    private void refresh() {
        GUI.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SysTray.this.item == null || SysTray.this.item.isDisposed()) {
                    return;
                }
                try {
                    Object s = "Jameica";
                    if (SysTray.this.activity) {
                        s = (String)s + ": " + Application.getI18n().tr("Neue Aktivit\u00e4t");
                    }
                    SysTray.this.item.setToolTipText((String)s);
                    SysTray.this.item.setImage(SWTUtil.getImage(SysTray.this.activity ? "jameica-icon-notify.png" : "jameica-icon.png"));
                }
                catch (Exception e) {
                    Logger.error((String)"unable to refresh icon", (Throwable)e);
                }
            }
        });
    }
}

